/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare.array;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.condition.compare.LenientCompare;
import org.elasticsearch.watcher.support.xcontent.WatcherXContentUtils;

public class ArrayCompareCondition
implements Condition {
    public static final String TYPE = "array_compare";
    private String arrayPath;
    private String path;
    private Op op;
    private Object value;
    private Quantifier quantifier;

    public ArrayCompareCondition(String arrayPath, String path, Op op, Object value, Quantifier quantifier) {
        this.arrayPath = arrayPath;
        this.path = path;
        this.op = op;
        this.value = value;
        this.quantifier = quantifier;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public String getArrayPath() {
        return this.arrayPath;
    }

    public String getPath() {
        return this.path;
    }

    public Op getOp() {
        return this.op;
    }

    public Object getValue() {
        return this.value;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayCompareCondition that = (ArrayCompareCondition)o;
        return Objects.equals(this.getArrayPath(), that.getArrayPath()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals((Object)this.getOp(), (Object)that.getOp()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals((Object)this.getQuantifier(), (Object)that.getQuantifier());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getArrayPath(), this.getPath(), this.getOp(), this.getValue(), this.getQuantifier()});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().startObject(this.arrayPath).field(Field.PATH.getPreferredName(), this.path).startObject(this.op.id()).field(Field.VALUE.getPreferredName(), this.value).field(Field.QUANTIFIER.getPreferredName(), this.quantifier.id()).endObject().endObject().endObject();
    }

    public static ArrayCompareCondition parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        String arrayPath = null;
        String path = null;
        Op op = null;
        Object value = null;
        boolean haveValue = false;
        Quantifier quantifier = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                arrayPath = parser.currentName();
                continue;
            }
            if (arrayPath == null) {
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        if (ParseFieldMatcher.STRICT.match(parser.currentName(), Field.PATH)) {
                            parser.nextToken();
                            path = parser.text();
                            continue;
                        }
                        if (op != null) {
                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate comparison operator, but already saw [{}].", new Object[]{TYPE, watchId, parser.currentName(), op.id()});
                        }
                        try {
                            op = Op.resolve(parser.currentName());
                        }
                        catch (IllegalArgumentException iae) {
                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison operator [{}]", new Object[]{TYPE, watchId, parser.currentName(), iae});
                        }
                        token = parser.nextToken();
                        if (token == XContentParser.Token.START_OBJECT) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    if (ParseFieldMatcher.STRICT.match(parser.currentName(), Field.VALUE)) {
                                        if (haveValue) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate field \"value\", but already saw value [{}].", new Object[]{TYPE, watchId, value});
                                        }
                                        token = parser.nextToken();
                                        if (!op.supportsStructures() && !token.isValue() && token != XContentParser.Token.VALUE_NULL) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. compared value for [{}] with operation [{}] must either be a numeric, string, boolean or null value, but found [{}] instead", new Object[]{TYPE, watchId, path, op.name().toLowerCase(Locale.ROOT), token});
                                        }
                                        value = WatcherXContentUtils.readValue(parser, token);
                                        haveValue = true;
                                        continue;
                                    }
                                    if (ParseFieldMatcher.STRICT.match(parser.currentName(), Field.QUANTIFIER)) {
                                        if (quantifier != null) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate field \"quantifier\", but already saw quantifier [{}].", new Object[]{TYPE, watchId, quantifier.id()});
                                        }
                                        parser.nextToken();
                                        try {
                                            quantifier = Quantifier.resolve(parser.text());
                                            continue;
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison quantifier [{}]", new Object[]{TYPE, watchId, parser.text(), iae});
                                        }
                                    }
                                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison value or comparison quantifier, but found [{}] instead", new Object[]{TYPE, watchId, parser.currentName()});
                                }
                                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison value or comparison quantifier, but found [{}] instead", new Object[]{TYPE, watchId, token});
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, op.id(), token});
                    }
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path or a comparison operator, but found [{}] instead", new Object[]{TYPE, watchId, token});
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, path, token});
        }
        if (path == null) {
            path = "";
        }
        if (quantifier == null) {
            quantifier = Quantifier.SOME;
        }
        return new ArrayCompareCondition(arrayPath, path, op, value, quantifier);
    }

    public static Builder builder(String arrayPath, String path, Op op, Object value, Quantifier quantifier) {
        return new Builder(arrayPath, path, op, value, quantifier);
    }

    static interface Field {
        public static final ParseField PATH = new ParseField("path", new String[0]);
        public static final ParseField VALUE = new ParseField("value", new String[0]);
        public static final ParseField QUANTIFIER = new ParseField("quantifier", new String[0]);
    }

    public static class Builder
    implements Condition.Builder<ArrayCompareCondition> {
        private String arrayPath;
        private String path;
        private Op op;
        private Object value;
        private Quantifier quantifier;

        private Builder(String arrayPath, String path, Op op, Object value, Quantifier quantifier) {
            this.arrayPath = arrayPath;
            this.path = path;
            this.op = op;
            this.value = value;
            this.quantifier = quantifier;
        }

        @Override
        public ArrayCompareCondition build() {
            return new ArrayCompareCondition(this.arrayPath, this.path, this.op, this.value, this.quantifier);
        }
    }

    public static enum Quantifier {
        ALL{

            @Override
            public boolean eval(List<Object> values, Object configuredValue, Op op) {
                for (Object value : values) {
                    Integer compare = LenientCompare.compare(value, configuredValue);
                    boolean comparison = compare != null && op.comparison(compare);
                    if (comparison) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        SOME{

            @Override
            public boolean eval(List<Object> values, Object configuredValue, Op op) {
                for (Object value : values) {
                    Integer compare = LenientCompare.compare(value, configuredValue);
                    boolean comparison = compare != null && op.comparison(compare);
                    if (!comparison) continue;
                    return true;
                }
                return false;
            }
        };


        public abstract boolean eval(List<Object> var1, Object var2, Op var3);

        public static Quantifier resolve(String id) {
            return Quantifier.valueOf(id.toUpperCase(Locale.ROOT));
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Op {
        EQ{

            @Override
            public boolean comparison(int x) {
                return x == 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        NOT_EQ{

            @Override
            public boolean comparison(int x) {
                return x != 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        GTE{

            @Override
            public boolean comparison(int x) {
                return x >= 0;
            }
        }
        ,
        GT{

            @Override
            public boolean comparison(int x) {
                return x > 0;
            }
        }
        ,
        LTE{

            @Override
            public boolean comparison(int x) {
                return x <= 0;
            }
        }
        ,
        LT{

            @Override
            public boolean comparison(int x) {
                return x < 0;
            }
        };


        public abstract boolean comparison(int var1);

        public boolean supportsStructures() {
            return false;
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Op resolve(String id) {
            return Op.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }

    public static class Result
    extends Condition.Result {
        @Nullable
        private final Map<String, Object> resolvedValues;

        Result(Map<String, Object> resolvedValues, boolean met) {
            super(ArrayCompareCondition.TYPE, met);
            this.resolvedValues = resolvedValues;
        }

        Result(@Nullable Map<String, Object> resolvedValues, Exception e) {
            super(ArrayCompareCondition.TYPE, e);
            this.resolvedValues = resolvedValues;
        }

        public Map<String, Object> getResolvedValues() {
            return this.resolvedValues;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.resolvedValues == null) {
                return builder;
            }
            return builder.startObject(this.type).field(Field.RESOLVED_VALUES.getPreferredName(), this.resolvedValues).endObject();
        }

        public static interface Field
        extends Condition.Field {
            public static final ParseField RESOLVED_VALUES = new ParseField("resolved_values", new String[0]);
        }
    }
}

