/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.ConditionFactory;
import org.elasticsearch.watcher.condition.compare.CompareCondition;
import org.elasticsearch.watcher.condition.compare.ExecutableCompareCondition;
import org.elasticsearch.watcher.support.clock.Clock;

public class CompareConditionFactory
extends ConditionFactory<CompareCondition, CompareCondition.Result, ExecutableCompareCondition> {
    private final Clock clock;

    @Inject
    public CompareConditionFactory(Settings settings, Clock clock) {
        super(Loggers.getLogger(ExecutableCompareCondition.class, (Settings)settings, (String[])new String[0]));
        this.clock = clock;
    }

    @Override
    public String type() {
        return "compare";
    }

    @Override
    public CompareCondition parseCondition(String watchId, XContentParser parser) throws IOException {
        return CompareCondition.parse(watchId, parser);
    }

    @Override
    public ExecutableCompareCondition createExecutable(CompareCondition condition) {
        return new ExecutableCompareCondition(condition, this.conditionLogger, this.clock);
    }
}

