/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.condition.ConditionFactory;
import org.elasticsearch.watcher.condition.ExecutableCondition;

public class ConditionRegistry {
    private final ImmutableMap<String, ConditionFactory> factories;

    @Inject
    public ConditionRegistry(Map<String, ConditionFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public Set<String> types() {
        return this.factories.keySet();
    }

    public ExecutableCondition parseExecutable(String watchId, XContentParser parser) throws IOException {
        Condition condition = this.parseCondition(watchId, parser);
        return ((ConditionFactory)this.factories.get((Object)condition.type())).createExecutable(condition);
    }

    public Condition parseCondition(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        Condition condition = null;
        ConditionFactory factory = null;
        String type = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) {
                throw new ElasticsearchParseException("could not parse condition for watch [{}]. invalid definition. expected a field indicating the condition type, but found", new Object[]{watchId, token});
            }
            factory = (ConditionFactory)this.factories.get((Object)type);
            if (factory == null) {
                throw new ElasticsearchParseException("could not parse condition for watch [{}]. unknown condition type [{}]", new Object[]{watchId, type});
            }
            condition = (Condition)factory.parseCondition(watchId, parser);
        }
        if (condition == null) {
            throw new ElasticsearchParseException("could not parse condition for watch [{}]. missing required condition type field", new Object[]{watchId});
        }
        return condition;
    }

    public static void writeResult(Condition.Result result, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(Condition.Field.MET.getPreferredName(), result.met()).field(result.type(), (ToXContent)result, params).endObject();
    }
}

