/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.watcher.condition.ConditionFactory;
import org.elasticsearch.watcher.condition.ConditionRegistry;
import org.elasticsearch.watcher.condition.always.AlwaysConditionFactory;
import org.elasticsearch.watcher.condition.compare.CompareConditionFactory;
import org.elasticsearch.watcher.condition.compare.array.ArrayCompareConditionFactory;
import org.elasticsearch.watcher.condition.never.NeverConditionFactory;
import org.elasticsearch.watcher.condition.script.ScriptConditionFactory;

public class ConditionModule
extends AbstractModule {
    private final Map<String, Class<? extends ConditionFactory>> factories = new HashMap<String, Class<? extends ConditionFactory>>();

    public void registerCondition(String type, Class<? extends ConditionFactory> factoryType) {
        this.factories.put(type, factoryType);
    }

    protected void configure() {
        MapBinder factoriesBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ConditionFactory.class);
        this.bind(ScriptConditionFactory.class).asEagerSingleton();
        factoriesBinder.addBinding((Object)"script").to(ScriptConditionFactory.class);
        this.bind(NeverConditionFactory.class).asEagerSingleton();
        factoriesBinder.addBinding((Object)"never").to(NeverConditionFactory.class);
        this.bind(AlwaysConditionFactory.class).asEagerSingleton();
        factoriesBinder.addBinding((Object)"always").to(AlwaysConditionFactory.class);
        this.bind(CompareConditionFactory.class).asEagerSingleton();
        factoriesBinder.addBinding((Object)"compare").to(CompareConditionFactory.class);
        this.bind(ArrayCompareConditionFactory.class).asEagerSingleton();
        factoriesBinder.addBinding((Object)"array_compare").to(ArrayCompareConditionFactory.class);
        for (Map.Entry<String, Class<? extends ConditionFactory>> entry : this.factories.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            factoriesBinder.addBinding((Object)entry.getKey()).to(entry.getValue());
        }
        this.bind(ConditionRegistry.class).asEagerSingleton();
    }
}

