/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.throttler;

import org.elasticsearch.watcher.actions.ActionStatus;
import org.elasticsearch.watcher.actions.throttler.Throttler;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;

public class AckThrottler
implements Throttler {
    @Override
    public Throttler.Result throttle(String actionId, WatchExecutionContext ctx) {
        ActionStatus actionStatus = ctx.watch().status().actionStatus(actionId);
        ActionStatus.AckStatus ackStatus = actionStatus.ackStatus();
        if (ackStatus.state() == ActionStatus.AckStatus.State.ACKED) {
            return Throttler.Result.throttle("action [{}] was acked at [{}]", actionId, WatcherDateTimeUtils.formatDate(ackStatus.timestamp()));
        }
        return Throttler.Result.NO;
    }
}

