/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.slack.service.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.slack.service.message.Attachment;
import org.elasticsearch.watcher.actions.slack.service.message.DynamicAttachments;
import org.elasticsearch.watcher.actions.slack.service.message.MessageElement;
import org.elasticsearch.watcher.actions.slack.service.message.SlackMessageDefaults;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class SlackMessage
implements MessageElement {
    final String from;
    final String[] to;
    final String icon;
    final String text;
    final Attachment[] attachments;

    public SlackMessage(String from, String[] to, String icon, String text, Attachment[] attachments) {
        this.from = from;
        this.to = to;
        this.icon = icon;
        this.text = text;
        this.attachments = attachments;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getTo() {
        return this.to;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessage that = (SlackMessage)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (!Arrays.equals(this.to, that.to)) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return Arrays.equals(this.attachments, that.attachments);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? Arrays.hashCode(this.to) : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.attachments != null ? Arrays.hashCode(this.attachments) : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeTargets) throws IOException {
        builder.startObject();
        if (this.from != null) {
            builder.field(XField.FROM.getPreferredName(), this.from);
        }
        if (includeTargets && this.to != null) {
            builder.array(XField.TO.getPreferredName(), this.to);
        }
        if (this.icon != null) {
            builder.field(XField.ICON.getPreferredName(), this.icon);
        }
        if (this.text != null) {
            builder.field(XField.TEXT.getPreferredName(), this.text);
        }
        if (this.attachments != null) {
            builder.startArray(XField.ATTACHMENTS.getPreferredName());
            for (Attachment attachment : this.attachments) {
                attachment.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    static interface XField
    extends MessageElement.XField {
        public static final ParseField FROM = new ParseField("from", new String[0]);
        public static final ParseField TO = new ParseField("to", new String[0]);
        public static final ParseField ICON = new ParseField("icon", new String[0]);
        public static final ParseField ATTACHMENTS = new ParseField("attachments", new String[0]);
        public static final ParseField DYNAMIC_ATTACHMENTS = new ParseField("dynamic_attachments", new String[0]);
    }

    public static class Template
    implements ToXContent {
        final TextTemplate from;
        final TextTemplate[] to;
        final TextTemplate text;
        final TextTemplate icon;
        final Attachment.Template[] attachments;
        final DynamicAttachments dynamicAttachments;

        public Template(TextTemplate from, TextTemplate[] to, TextTemplate text, TextTemplate icon, Attachment.Template[] attachments, DynamicAttachments dynamicAttachments) {
            this.from = from;
            this.to = to;
            this.text = text;
            this.icon = icon;
            this.attachments = attachments;
            this.dynamicAttachments = dynamicAttachments;
        }

        public TextTemplate getFrom() {
            return this.from;
        }

        public TextTemplate[] getTo() {
            return this.to;
        }

        public TextTemplate getText() {
            return this.text;
        }

        public TextTemplate getIcon() {
            return this.icon;
        }

        public Attachment.Template[] getAttachments() {
            return this.attachments;
        }

        public DynamicAttachments dynamicAttachments() {
            return this.dynamicAttachments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            if (this.from != null ? !this.from.equals(template.from) : template.from != null) {
                return false;
            }
            if (!Arrays.equals(this.to, template.to)) {
                return false;
            }
            if (this.text != null ? !this.text.equals(template.text) : template.text != null) {
                return false;
            }
            if (this.icon != null ? !this.icon.equals(template.icon) : template.icon != null) {
                return false;
            }
            if (!Arrays.equals(this.attachments, template.attachments)) {
                return false;
            }
            return !(this.dynamicAttachments == null ? template.dynamicAttachments != null : !this.dynamicAttachments.equals(template.dynamicAttachments));
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.to != null ? Arrays.hashCode(this.to) : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
            result = 31 * result + (this.attachments != null ? Arrays.hashCode(this.attachments) : 0);
            result = 31 * result + (this.dynamicAttachments != null ? this.dynamicAttachments.hashCode() : 0);
            return result;
        }

        public SlackMessage render(String watchId, String actionId, TextTemplateEngine engine, Map<String, Object> model, SlackMessageDefaults defaults) {
            String from = this.from != null ? engine.render(this.from, model) : (defaults.from != null ? defaults.from : watchId);
            String[] to = defaults.to;
            if (this.to != null) {
                to = new String[this.to.length];
                for (int i = 0; i < to.length; ++i) {
                    to[i] = engine.render(this.to[i], model);
                }
            }
            String text = this.text != null ? engine.render(this.text, model) : defaults.text;
            String icon = this.icon != null ? engine.render(this.icon, model) : defaults.icon;
            ArrayList<Attachment> attachments = null;
            if (this.attachments != null) {
                attachments = new ArrayList<Attachment>();
                for (Attachment.Template attachment : this.attachments) {
                    attachments.add(attachment.render(engine, model, defaults.attachment));
                }
            }
            if (this.dynamicAttachments != null) {
                if (attachments == null) {
                    attachments = new ArrayList();
                }
                attachments.addAll(this.dynamicAttachments.render(engine, model, defaults.attachment));
            }
            if (attachments == null) {
                return new SlackMessage(from, to, icon, text, null);
            }
            return new SlackMessage(from, to, icon, text, attachments.toArray(new Attachment[attachments.size()]));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.from != null) {
                builder.field(XField.FROM.getPreferredName(), (ToXContent)this.from);
            }
            if (this.to != null) {
                builder.startArray(XField.TO.getPreferredName());
                for (TextTemplate template : this.to) {
                    template.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.text != null) {
                builder.field(XField.TEXT.getPreferredName(), (ToXContent)this.text, params);
            }
            if (this.icon != null) {
                builder.field(XField.ICON.getPreferredName(), (ToXContent)this.icon, params);
            }
            if (this.attachments != null) {
                builder.startArray(XField.ATTACHMENTS.getPreferredName());
                for (Attachment.Template attachment : this.attachments) {
                    attachment.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.dynamicAttachments != null) {
                builder.field(XField.DYNAMIC_ATTACHMENTS.getPreferredName(), (ToXContent)this.dynamicAttachments, params);
            }
            return builder.endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.FROM)) {
                    try {
                        builder.setFrom(TextTemplate.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.FROM.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TO)) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                builder.addTo(TextTemplate.parse(parser));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field.", (Throwable)pe, new Object[]{XField.TO.getPreferredName()});
                            }
                        }
                        continue;
                    }
                    try {
                        builder.addTo(TextTemplate.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TO.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.TEXT)) {
                    try {
                        builder.setText(TextTemplate.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TEXT.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.ICON)) {
                    try {
                        builder.setIcon(TextTemplate.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field.", (Throwable)pe, new Object[]{XField.ICON.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.ATTACHMENTS)) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                builder.addAttachments(Attachment.Template.parse(parser));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field.", (Throwable)pe, new Object[]{XField.ATTACHMENTS.getPreferredName()});
                            }
                        }
                        continue;
                    }
                    try {
                        builder.addAttachments(Attachment.Template.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field.", (Throwable)pe, new Object[]{XField.ATTACHMENTS.getPreferredName()});
                    }
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, XField.DYNAMIC_ATTACHMENTS)) {
                    try {
                        builder.setDynamicAttachments(DynamicAttachments.parse(parser));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse slack message. failed to parse [{}] field.", (Throwable)pe, new Object[]{XField.ICON.getPreferredName()});
                    }
                }
                throw new ElasticsearchParseException("could not parse slack message. unknown field [{}].", new Object[]{currentFieldName});
            }
            return builder.build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            TextTemplate from;
            final List<TextTemplate> to = new ArrayList<TextTemplate>();
            TextTemplate text;
            TextTemplate icon;
            final List<Attachment.Template> attachments = new ArrayList<Attachment.Template>();
            DynamicAttachments dynamicAttachments;

            private Builder() {
            }

            public Builder setFrom(TextTemplate from) {
                this.from = from;
                return this;
            }

            public Builder setFrom(TextTemplate.Builder from) {
                return this.setFrom(from.build());
            }

            public Builder setFrom(String from) {
                return this.setFrom(TextTemplate.inline(from));
            }

            public Builder addTo(TextTemplate ... to) {
                Collections.addAll(this.to, to);
                return this;
            }

            public Builder addTo(TextTemplate.Builder ... to) {
                for (TextTemplate.Builder name : to) {
                    this.to.add(name.build());
                }
                return this;
            }

            public Builder addTo(String ... to) {
                for (String name : to) {
                    this.to.add(TextTemplate.inline(name).build());
                }
                return this;
            }

            public Builder setText(TextTemplate text) {
                this.text = text;
                return this;
            }

            public Builder setText(TextTemplate.Builder text) {
                return this.setText(text.build());
            }

            public Builder setText(String text) {
                return this.setText(TextTemplate.inline(text));
            }

            public Builder setIcon(TextTemplate icon) {
                this.icon = icon;
                return this;
            }

            public Builder setIcon(TextTemplate.Builder icon) {
                return this.setIcon(icon.build());
            }

            public Builder setIcon(String icon) {
                return this.setIcon(TextTemplate.inline(icon));
            }

            public Builder addAttachments(Attachment.Template ... attachments) {
                Collections.addAll(this.attachments, attachments);
                return this;
            }

            public Builder addAttachments(Attachment.Template.Builder ... attachments) {
                for (Attachment.Template.Builder attachment : attachments) {
                    this.attachments.add(attachment.build());
                }
                return this;
            }

            public Builder setDynamicAttachments(DynamicAttachments dynamicAttachments) {
                this.dynamicAttachments = dynamicAttachments;
                return this;
            }

            public Template build() {
                TextTemplate[] to = this.to.isEmpty() ? null : this.to.toArray(new TextTemplate[this.to.size()]);
                Attachment.Template[] attachments = this.attachments.isEmpty() ? null : this.attachments.toArray(new Attachment.Template[this.attachments.size()]);
                return new Template(this.from, to, this.text, this.icon, attachments, this.dynamicAttachments);
            }
        }
    }
}

