/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.logging;

import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.logging.LoggingAction;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableLoggingAction
extends ExecutableAction<LoggingAction> {
    private final ESLogger textLogger;
    private final TextTemplateEngine templateEngine;

    ExecutableLoggingAction(LoggingAction action, ESLogger logger, Settings settings, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.textLogger = action.category != null ? Loggers.getLogger((String)action.category, (Settings)settings, (String[])new String[0]) : logger;
        this.templateEngine = templateEngine;
    }

    ExecutableLoggingAction(LoggingAction action, ESLogger logger, ESLogger textLogger, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.textLogger = textLogger;
        this.templateEngine = templateEngine;
    }

    ESLogger textLogger() {
        return this.textLogger;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        String loggedText = this.templateEngine.render(((LoggingAction)this.action).text, model);
        if (ctx.simulateAction(actionId)) {
            return new LoggingAction.Result.Simulated(loggedText);
        }
        ((LoggingAction)this.action).level.log(this.textLogger, loggedText);
        return new LoggingAction.Result.Success(loggedText);
    }
}

