/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.hipchat.service;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatAccount;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatServer;
import org.elasticsearch.watcher.support.http.HttpClient;

public class HipChatAccounts {
    private final Map<String, HipChatAccount> accounts;
    private final String defaultAccountName;

    public HipChatAccounts(Settings settings, HttpClient httpClient, ESLogger logger) {
        HipChatServer defaultServer = new HipChatServer(settings);
        Settings accountsSettings = settings.getAsSettings("account");
        this.accounts = new HashMap<String, HipChatAccount>();
        for (String name : accountsSettings.names()) {
            Settings accountSettings = accountsSettings.getAsSettings(name);
            HipChatAccount.Profile profile = HipChatAccount.Profile.resolve(accountSettings, "profile", null);
            if (profile == null) {
                throw new SettingsException("missing [profile] setting for hipchat account [" + name + "]");
            }
            HipChatAccount account = profile.createAccount(name, accountSettings, defaultServer, httpClient, logger);
            this.accounts.put(name, account);
        }
        String defaultAccountName = settings.get("default_account");
        if (defaultAccountName == null) {
            if (this.accounts.isEmpty()) {
                this.defaultAccountName = null;
            } else {
                HipChatAccount account = this.accounts.values().iterator().next();
                logger.info("default hipchat account set to [{}]", new Object[]{account.name});
                this.defaultAccountName = account.name;
            }
        } else {
            if (!this.accounts.containsKey(defaultAccountName)) {
                throw new SettingsException("could not find default hipchat account [" + defaultAccountName + "]");
            }
            this.defaultAccountName = defaultAccountName;
        }
    }

    public HipChatAccount account(String name) throws IllegalStateException {
        if (name == null) {
            if (this.defaultAccountName == null) {
                throw new IllegalStateException("cannot find default hipchat account as no accounts have been configured");
            }
            name = this.defaultAccountName;
        }
        return this.accounts.get(name);
    }
}

