/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.hipchat;

import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.hipchat.HipChatAction;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatAccount;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatMessage;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatService;
import org.elasticsearch.watcher.actions.hipchat.service.SentMessages;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableHipChatAction
extends ExecutableAction<HipChatAction> {
    private final TextTemplateEngine templateEngine;
    private final HipChatService hipchatService;

    public ExecutableHipChatAction(HipChatAction action, ESLogger logger, HipChatService hipchatService, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.hipchatService = hipchatService;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        HipChatAccount account = ((HipChatAction)this.action).account != null ? this.hipchatService.getAccount(((HipChatAction)this.action).account) : this.hipchatService.getDefaultAccount();
        account.validateParsedTemplate(ctx.id().watchId(), actionId, ((HipChatAction)this.action).message);
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HipChatMessage message = account.render(ctx.id().watchId(), actionId, this.templateEngine, ((HipChatAction)this.action).message, model);
        if (ctx.simulateAction(actionId)) {
            return new HipChatAction.Result.Simulated(message);
        }
        SentMessages sentMessages = account.send(message);
        return new HipChatAction.Result.Executed(sentMessages);
    }
}

