/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions.email;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.email.DataAttachment;
import org.elasticsearch.watcher.actions.email.service.Authentication;
import org.elasticsearch.watcher.actions.email.service.Email;
import org.elasticsearch.watcher.actions.email.service.EmailTemplate;
import org.elasticsearch.watcher.actions.email.service.Profile;
import org.elasticsearch.watcher.support.secret.Secret;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.support.xcontent.WatcherXContentParser;

public class EmailAction
implements Action {
    public static final String TYPE = "email";
    private final EmailTemplate email;
    @Nullable
    private final String account;
    @Nullable
    private final Authentication auth;
    @Nullable
    private final Profile profile;
    @Nullable
    private final DataAttachment dataAttachment;

    public EmailAction(EmailTemplate email, @Nullable String account, @Nullable Authentication auth, @Nullable Profile profile, @Nullable DataAttachment dataAttachment) {
        this.email = email;
        this.account = account;
        this.auth = auth;
        this.profile = profile;
        this.dataAttachment = dataAttachment;
    }

    public EmailTemplate getEmail() {
        return this.email;
    }

    public String getAccount() {
        return this.account;
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public DataAttachment getDataAttachment() {
        return this.dataAttachment;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAction action = (EmailAction)o;
        if (!this.email.equals(action.email)) {
            return false;
        }
        if (this.account != null ? !this.account.equals(action.account) : action.account != null) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(action.auth) : action.auth != null) {
            return false;
        }
        if (this.profile != action.profile) {
            return false;
        }
        return !(this.dataAttachment == null ? action.dataAttachment != null : !this.dataAttachment.equals((Object)action.dataAttachment));
    }

    public int hashCode() {
        int result = this.email.hashCode();
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + (this.dataAttachment != null ? this.dataAttachment.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.account != null) {
            builder.field(Field.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.auth != null) {
            builder.field(Field.USER.getPreferredName(), this.auth.user());
            if (!WatcherParams.hideSecrets(params)) {
                builder.field(Field.PASSWORD.getPreferredName(), (ToXContent)this.auth.password(), params);
            }
        }
        if (this.profile != null) {
            builder.field(Field.PROFILE.getPreferredName(), this.profile.name().toLowerCase(Locale.ROOT));
        }
        if (this.dataAttachment != null) {
            builder.field(Field.ATTACH_DATA.getPreferredName(), (ToXContent)this.dataAttachment, params);
        }
        this.email.xContentBody(builder, params);
        return builder.endObject();
    }

    public static EmailAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        EmailTemplate.Parser emailParser = new EmailTemplate.Parser();
        String account = null;
        String user = null;
        Secret password = null;
        Profile profile = Profile.STANDARD;
        DataAttachment dataAttachment = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ATTACH_DATA)) {
                try {
                    dataAttachment = DataAttachment.parse(parser);
                    continue;
                }
                catch (IOException ioe) {
                    throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. failed to parse data attachment field [{}]", (Throwable)ioe, new Object[]{TYPE, watchId, actionId, currentFieldName});
                }
            }
            if (emailParser.handle(currentFieldName, parser)) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACCOUNT)) {
                    account = parser.text();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.USER)) {
                    user = parser.text();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PASSWORD)) {
                    password = WatcherXContentParser.secretOrNull(parser);
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PROFILE)) {
                    try {
                        profile = Profile.resolve(parser.text());
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]", new Object[]{TYPE, watchId, actionId, iae});
                    }
                }
                throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. unexpected string field [{}]", new Object[]{TYPE, watchId, actionId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. unexpected token [{}]", new Object[]{TYPE, watchId, actionId, token});
        }
        Authentication auth = null;
        if (user != null) {
            auth = new Authentication(user, password);
        }
        return new EmailAction(emailParser.parsedTemplate(), account, auth, profile, dataAttachment);
    }

    public static Builder builder(EmailTemplate email) {
        return new Builder(email);
    }

    static interface Field
    extends Action.Field {
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField PROFILE = new ParseField("profile", new String[0]);
        public static final ParseField USER = new ParseField("user", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
        public static final ParseField ATTACH_DATA = new ParseField("attach_data", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
    }

    public static class Builder
    implements Action.Builder<EmailAction> {
        final EmailTemplate email;
        @Nullable
        String account;
        @Nullable
        Authentication auth;
        @Nullable
        Profile profile;
        @Nullable
        DataAttachment dataAttachment;

        private Builder(EmailTemplate email) {
            this.email = email;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setAuthentication(String username, char[] password) {
            this.auth = new Authentication(username, new Secret(password));
            return this;
        }

        public Builder setProfile(Profile profile) {
            this.profile = profile;
            return this;
        }

        public Builder setAttachPayload(DataAttachment dataAttachment) {
            this.dataAttachment = dataAttachment;
            return this;
        }

        @Override
        public EmailAction build() {
            return new EmailAction(this.email, this.account, this.auth, this.profile, this.dataAttachment);
        }
    }

    public static abstract class Result
    extends Action.Result {
        protected Result(Action.Result.Status status) {
            super(EmailAction.TYPE, status);
        }

        public static class Simulated
        extends Result {
            private final Email email;

            public Email email() {
                return this.email;
            }

            Simulated(Email email) {
                super(Action.Result.Status.SIMULATED);
                this.email = email;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.MESSAGE.getPreferredName(), (ToXContent)this.email, params).endObject();
            }
        }

        public static class Success
        extends Result {
            private final String account;
            private final Email email;

            Success(String account, Email email) {
                super(Action.Result.Status.SUCCESS);
                this.account = account;
                this.email = email;
            }

            public String account() {
                return this.account;
            }

            public Email email() {
                return this.email;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.ACCOUNT.getPreferredName(), this.account).field(Field.MESSAGE.getPreferredName(), (ToXContent)this.email, params).endObject();
            }
        }
    }
}

