/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.ActionRegistry;
import org.elasticsearch.watcher.actions.email.EmailActionFactory;
import org.elasticsearch.watcher.actions.email.service.EmailService;
import org.elasticsearch.watcher.actions.email.service.HtmlSanitizer;
import org.elasticsearch.watcher.actions.email.service.InternalEmailService;
import org.elasticsearch.watcher.actions.hipchat.HipChatActionFactory;
import org.elasticsearch.watcher.actions.hipchat.service.HipChatService;
import org.elasticsearch.watcher.actions.hipchat.service.InternalHipChatService;
import org.elasticsearch.watcher.actions.index.IndexActionFactory;
import org.elasticsearch.watcher.actions.logging.LoggingActionFactory;
import org.elasticsearch.watcher.actions.slack.SlackActionFactory;
import org.elasticsearch.watcher.actions.slack.service.InternalSlackService;
import org.elasticsearch.watcher.actions.slack.service.SlackService;
import org.elasticsearch.watcher.actions.webhook.WebhookActionFactory;

public class WatcherActionModule
extends AbstractModule {
    private final Map<String, Class<? extends ActionFactory>> parsers = new HashMap<String, Class<? extends ActionFactory>>();

    public WatcherActionModule() {
        this.registerAction("email", EmailActionFactory.class);
        this.registerAction("webhook", WebhookActionFactory.class);
        this.registerAction("index", IndexActionFactory.class);
        this.registerAction("logging", LoggingActionFactory.class);
        this.registerAction("hipchat", HipChatActionFactory.class);
        this.registerAction("slack", SlackActionFactory.class);
    }

    public void registerAction(String type, Class<? extends ActionFactory> parserType) {
        this.parsers.put(type, parserType);
    }

    protected void configure() {
        MapBinder parsersBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ActionFactory.class);
        for (Map.Entry<String, Class<? extends ActionFactory>> entry : this.parsers.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            parsersBinder.addBinding((Object)entry.getKey()).to(entry.getValue());
        }
        this.bind(ActionRegistry.class).asEagerSingleton();
        this.bind(HtmlSanitizer.class).asEagerSingleton();
        this.bind(EmailService.class).to(InternalEmailService.class).asEagerSingleton();
        this.bind(HipChatService.class).to(InternalHipChatService.class).asEagerSingleton();
        this.bind(SlackService.class).to(InternalSlackService.class).asEagerSingleton();
    }
}

