/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.actions;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ActionFactory;
import org.elasticsearch.watcher.actions.ActionRegistry;
import org.elasticsearch.watcher.actions.ExecutableAction;
import org.elasticsearch.watcher.actions.throttler.ActionThrottler;
import org.elasticsearch.watcher.actions.throttler.Throttler;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.TransformRegistry;
import org.elasticsearch.watcher.watch.Payload;

public class ActionWrapper
implements ToXContent {
    private String id;
    @Nullable
    private final ExecutableTransform transform;
    private final ActionThrottler throttler;
    private final ExecutableAction action;

    public ActionWrapper(String id, ExecutableAction action) {
        this(id, null, null, action);
    }

    public ActionWrapper(String id, ActionThrottler throttler, @Nullable ExecutableTransform transform, ExecutableAction action) {
        this.id = id;
        this.throttler = throttler;
        this.transform = transform;
        this.action = action;
    }

    public String id() {
        return this.id;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ExecutableAction action() {
        return this.action;
    }

    public Result execute(WatchExecutionContext ctx) throws IOException {
        Throttler.Result throttleResult;
        Result result = ctx.actionsResults().get(this.id);
        if (result != null) {
            return result;
        }
        if (!ctx.skipThrottling(this.id) && (throttleResult = this.throttler.throttle(this.id, ctx)).throttle()) {
            return new Result(this.id, new Action.Result.Throttled(this.action.type(), throttleResult.reason()));
        }
        Payload payload = ctx.payload();
        Transform.Result transformResult = null;
        if (this.transform != null) {
            try {
                transformResult = (Transform.Result)this.transform.execute(ctx, payload);
                if (transformResult.status() == Transform.Result.Status.FAILURE) {
                    this.action.logger().error("failed to execute action [{}/{}]. failed to transform payload. {}", new Object[]{ctx.watch().id(), this.id, transformResult.reason()});
                    return new Result(this.id, transformResult, new Action.Result.Failure(this.action.type(), "Failed to transform payload", new Object[0]));
                }
                payload = transformResult.payload();
            }
            catch (Exception e) {
                this.action.logger().error("failed to execute action [{}/{}]. failed to transform payload.", (Throwable)e, new Object[]{ctx.watch().id(), this.id});
                return new Result(this.id, new Action.Result.Failure(this.action.type(), "Failed to transform payload. error: " + ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]));
            }
        }
        try {
            Action.Result actionResult = this.action.execute(this.id, ctx, payload);
            return new Result(this.id, transformResult, actionResult);
        }
        catch (Exception e) {
            this.action.logger().error("failed to execute action [{}/{}]", (Throwable)e, new Object[]{ctx.watch().id(), this.id});
            return new Result(this.id, new Action.Result.Failure(this.action.type(), ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionWrapper that = (ActionWrapper)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.transform != null ? !this.transform.equals(that.transform) : that.transform != null) {
            return false;
        }
        return this.action.equals(that.action);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.transform != null ? this.transform.hashCode() : 0);
        result = 31 * result + this.action.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        TimeValue throttlePeriod = this.throttler.throttlePeriod();
        if (throttlePeriod != null) {
            builder.field(Throttler.Field.THROTTLE_PERIOD.getPreferredName(), (Object)throttlePeriod);
        }
        if (this.transform != null) {
            builder.startObject(Transform.Field.TRANSFORM.getPreferredName()).field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        builder.field(this.action.type(), (ToXContent)this.action, params);
        return builder.endObject();
    }

    static ActionWrapper parse(String watchId, String actionId, XContentParser parser, ActionRegistry actionRegistry, TransformRegistry transformRegistry, Clock clock, WatcherLicensee watcherLicensee) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        ExecutableTransform transform = null;
        TimeValue throttlePeriod = null;
        ExecutableAction action = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Transform.Field.TRANSFORM)) {
                transform = transformRegistry.parse(watchId, parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Throttler.Field.THROTTLE_PERIOD)) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, Throttler.Field.THROTTLE_PERIOD.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse action [{}/{}]. failed to parse field [{}] as time value", (Throwable)pe, new Object[]{watchId, actionId, currentFieldName});
                }
            }
            ActionFactory actionFactory = actionRegistry.factory(currentFieldName);
            if (actionFactory == null) {
                throw new ElasticsearchParseException("could not parse action [{}/{}]. unknown action type [{}]", new Object[]{watchId, actionId, currentFieldName});
            }
            action = (ExecutableAction)actionFactory.parseExecutable(watchId, actionId, parser);
        }
        if (action == null) {
            throw new ElasticsearchParseException("could not parse watch action [{}/{}]. missing action type", new Object[]{watchId, actionId});
        }
        ActionThrottler throttler = new ActionThrottler(clock, throttlePeriod, watcherLicensee);
        return new ActionWrapper(actionId, throttler, transform, action);
    }

    static interface Field {
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField STATUS = new ParseField("status", new String[0]);
    }

    public static class Result
    implements ToXContent {
        private final String id;
        @Nullable
        private final Transform.Result transform;
        private final Action.Result action;

        public Result(String id, Action.Result action) {
            this(id, null, action);
        }

        public Result(String id, @Nullable Transform.Result transform, Action.Result action) {
            this.id = id;
            this.transform = transform;
            this.action = action;
        }

        public String id() {
            return this.id;
        }

        public Transform.Result transform() {
            return this.transform;
        }

        public Action.Result action() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (!this.id.equals(result.id)) {
                return false;
            }
            if (this.transform != null ? !this.transform.equals(result.transform) : result.transform != null) {
                return false;
            }
            return this.action.equals(result.action);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.transform != null ? this.transform.hashCode() : 0);
            result = 31 * result + this.action.hashCode();
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.ID.getPreferredName(), this.id);
            builder.field(Field.TYPE.getPreferredName(), this.action.type());
            builder.field(Field.STATUS.getPreferredName(), (ToXContent)this.action.status, params);
            if (this.transform != null) {
                builder.field(Transform.Field.TRANSFORM.getPreferredName(), (ToXContent)this.transform, params);
            }
            this.action.toXContent(builder, params);
            return builder.endObject();
        }
    }
}

