/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.io.IOException;
import java.util.EnumSet;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class WatcherMetaData
extends AbstractDiffable<MetaData.Custom>
implements MetaData.Custom {
    public static final String TYPE = "watcher";
    public static final WatcherMetaData PROTO = new WatcherMetaData(false);
    private final boolean manuallyStopped;

    public WatcherMetaData(boolean manuallyStopped) {
        this.manuallyStopped = manuallyStopped;
    }

    public boolean manuallyStopped() {
        return this.manuallyStopped;
    }

    public String type() {
        return TYPE;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return EnumSet.of(MetaData.XContentContext.GATEWAY);
    }

    public MetaData.Custom readFrom(StreamInput streamInput) throws IOException {
        return new WatcherMetaData(streamInput.readBoolean());
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeBoolean(this.manuallyStopped);
    }

    public MetaData.Custom fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    break;
                }
                case VALUE_BOOLEAN: {
                    if (!ParseFieldMatcher.STRICT.match(currentFieldName, Field.MANUALLY_STOPPED)) break;
                    return new WatcherMetaData(parser.booleanValue());
                }
            }
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Field.MANUALLY_STOPPED.getPreferredName(), this.manuallyStopped);
        return builder;
    }

    static interface Field {
        public static final ParseField MANUALLY_STOPPED = new ParseField("manually_stopped", new String[0]);
    }
}

